% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{age}
\alias{age}
\title{Age in Years of Individuals}
\usage{
age(x, reference = Sys.Date(), exact = FALSE, na.rm = FALSE, ...)
}
\arguments{
\item{x}{date(s), \link{character} (vectors) will be coerced with \code{\link[=as.POSIXlt]{as.POSIXlt()}}}

\item{reference}{reference date(s) (default is today), \link{character} (vectors) will be coerced with \code{\link[=as.POSIXlt]{as.POSIXlt()}}}

\item{exact}{a \link{logical} to indicate whether age calculation should be exact, i.e. with decimals. It divides the number of days of \href{https://en.wikipedia.org/wiki/Year-to-date}{year-to-date} (YTD) of \code{x} by the number of days in the year of \code{reference} (either 365 or 366).}

\item{na.rm}{a \link{logical} to indicate whether missing values should be removed}

\item{...}{arguments passed on to \code{\link[=as.POSIXlt]{as.POSIXlt()}}, such as \code{origin}}
}
\value{
An \link{integer} (no decimals) if \code{exact = FALSE}, a \link{double} (with decimals) otherwise
}
\description{
Calculates age in years based on a reference date, which is the system date at default.
}
\details{
Ages below 0 will be returned as \code{NA} with a warning. Ages above 120 will only give a warning.

This function vectorises over both \code{x} and \code{reference}, meaning that either can have a length of 1 while the other argument has a larger length.
}
\examples{
# 10 random pre-Y2K birth dates
df <- data.frame(birth_date = as.Date("2000-01-01") - runif(10) * 25000)

# add ages
df$age <- age(df$birth_date)

# add exact ages
df$age_exact <- age(df$birth_date, exact = TRUE)

# add age at millenium switch
df$age_at_y2k <- age(df$birth_date, "2000-01-01")

df
}
\seealso{
To split ages into groups, use the \code{\link[=age_groups]{age_groups()}} function.
}
