% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atc.R
\name{guess_bactid}
\alias{guess_bactid}
\title{Find bacteria ID based on genus/species}
\usage{
guess_bactid(x)
}
\arguments{
\item{x}{character vector to determine \code{bactid}}
}
\value{
Character (vector).
}
\description{
Use this function to determine a valid ID based on a genus (and species). This input could be a full name (like \code{"Staphylococcus aureus"}), an abbreviated name (like \code{"S. aureus"}), or just a genus. You could also use a \code{\link{paste}} of a genus and species column to use the full name as input: \code{x = paste(df$genus, df$species)}, where \code{df} is your dataframe.
}
\examples{
# These examples all return "STAAUR", the ID of S. aureus:
guess_bactid("stau")
guess_bactid("STAU")
guess_bactid("staaur")
guess_bactid("S. aureus")
guess_bactid("S aureus")
guess_bactid("Staphylococcus aureus")
guess_bactid("MRSA") # Methicillin-resistant S. aureus
guess_bactid("VISA") # Vancomycin Intermediate S. aureus
}
\seealso{
\code{\link{microorganisms}} for the dataframe that is being used to determine ID's.
}
