% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{as.rsi}
\alias{as.rsi}
\alias{is.rsi}
\title{Class 'rsi'}
\usage{
as.rsi(x)

is.rsi(x)
}
\arguments{
\item{x}{vector}
}
\value{
Ordered factor with new class \code{rsi} and new attributes \code{package} and \code{package.version}
}
\description{
This transforms a vector to a new class \code{rsi}, which is an ordered factor with levels \code{S < I < R}. Invalid antimicrobial interpretations will be translated as \code{NA} with a warning.
}
\examples{
rsi_data <- as.rsi(c(rep("S", 474), rep("I", 36), rep("R", 370)))
rsi_data <- as.rsi(c(rep("S", 474), rep("I", 36), rep("R", 370), "A", "B", "C"))
is.rsi(rsi_data)

plot(rsi_data)    # for percentages
barplot(rsi_data) # for frequencies
}
