% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/Getters.R
\docType{methods}
\name{getParameter}
\alias{getParameter}
\alias{getParameter,VoxelSpace,character-method}
\alias{getParameter,VoxelSpace,missing-method}
\title{Gets a parameter from the VoxelSpace header.}
\usage{
getParameter(vxsp, what)

\S4method{getParameter}{VoxelSpace,character}(vxsp, what)

\S4method{getParameter}{VoxelSpace,missing}(vxsp, what)
}
\arguments{
\item{vxsp}{the \code{\linkS4class{VoxelSpace}} object}

\item{what}{the name of the parameter. If missing returns all parameters.}
}
\value{
the parameter as a \code{character}
}
\description{
Gets a parameter from the VoxelSpace header.
}
\examples{
# load a voxel file
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
# show parameters name
names(getParameter(vxsp))
# retrieve 'mincorner' parameter
getParameter(vxsp, "mincorner")
# all parameters
getParameter(vxsp)
}
\seealso{
\code{\linkS4class{VoxelSpace}}
}
