% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot_intensity}
\alias{plot_intensity}
\title{Plot 2D intensity}
\usage{
plot_intensity(
  intensity,
  intensity_str = "T_SS_mat",
  frame = 1,
  sz = NA,
  title = NA,
  color = FALSE
)
}
\arguments{
\item{intensity}{intensity profile}

\item{intensity_str}{structure of the intensity profile, options from
('SST_array','S_ST_mat','T_SS_mat', 'SS_T_mat'). See 'Details'.}

\item{frame}{frame index}

\item{sz}{frame size of simulated image with default \code{c(200,200)}.}

\item{title}{main title of the plot. If \code{NA}, title is "intensity profile
for frame n" with n being the frame index in \code{frame}.}

\item{color}{a logical evaluating to TRUE or FALSE indicating whether a colorful
plot is generated}
}
\value{
2D plot in gray scale (or with color) of selected frame.
}
\description{
Function to plot 2D intensity profile for a certain frame, default is to plot
the first frame. Input can be a matrix (2D) or an array (3D).
}
\details{
By default \code{intensity_str} is set to 'T_SS_mat', a time by space\eqn{\times}{\%\times}space
matrix, which is the structure of intensity profile obtained from \code{simulation}
class. For \code{intensity_str='SST_array'} , input intensity profile should be a
space by space by time array, which is the structure from loading a tif file.
For \code{intensity_str='S_ST_mat'}, input intensity profile should be a
space by space\eqn{\times}{\%\times}time matrix. For \code{intensity_str='SS_T_mat'},
input intensity profile should be a space\eqn{\times}{\%\times}space by time matrix.
}
\examples{
library(AIUQ)
sim_bm = simulation(sz=100,len_t=100,sigma_bm=0.5)
show(sim_bm)
plot_intensity(sim_bm@intensity, sz=sim_bm@sz)

}
\author{
\packageAuthor{AIUQ}
}
