% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMVariogramAnalyser.R
\name{saveSpplotFromAFMImage}
\alias{saveSpplotFromAFMImage}
\title{Save on disk an AFMImage as a Lattice (trellis) plot}
\usage{
saveSpplotFromAFMImage(
  AFMImage,
  fullfilename,
  expectedWidth,
  expectHeight,
  withoutLegend
)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}

\item{fullfilename}{directory and filename to save to png}

\item{expectedWidth}{(optional) expected width of the saved image. Default is 400px.}

\item{expectHeight}{(optional) expected height of the saved image. Default is 300px.}

\item{withoutLegend}{(optional) set at FALSE, the cuts legend will be included in the plot. Default is FALSE.}
}
\description{
save a Lattice (trellis) plot of an \code{\link{AFMImage}} using the \code{\link[sp]{spplot}} method of the sp package.
This function is used to evaluate visually the quality of the predicted surface when a variogram model is used.
}
\details{
\code{saveSpplotFromAFMImage} save a a Lattice (trellis) plot of an \code{\link{AFMImage}} on disk
}
\examples{
\dontrun{
library(AFM)

data(AFMImageOfAluminiumInterface)
saveSpplotFromAFMImage(AFMImageOfAluminiumInterface,
                       paste(tempdir(), "myFileWithoutLegend.png", sep="/"), 800,800, TRUE)
saveSpplotFromAFMImage(AFMImageOfAluminiumInterface, 
                       paste(tempdir(), "myFileWithLegend.png", sep="/"), 800,800, FALSE)
}
}
\author{
M.Beauvais
}
