% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AFMVariogramAnalyser.R
\name{getSpplotFromAFMImage}
\alias{getSpplotFromAFMImage}
\title{Get an AFMImage as a Lattice (trellis) plot}
\usage{
getSpplotFromAFMImage(AFMImage, expectedWidth, expectHeight, withoutLegend)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}

\item{expectedWidth}{(optional) expected width of the saved image. Default is 400px.}

\item{expectHeight}{(optional) expected height of the saved image. Default is 300px.}

\item{withoutLegend}{(optional) set at FALSE, the cuts legend will be included in the plot. Default is FALSE.}
}
\description{
get a Lattice (trellis) plot of an \code{\link{AFMImage}} using the \code{\link[sp]{spplot}} method of the sp package.
This function is used to evaluate visually the quality of the predicted surface when a variogram model is used.
}
\details{
\code{getSpplotFromAFMImage} get a Lattice (trellis) plot of an \code{\link{AFMImage}} on disk
}
\examples{
\dontrun{
library(AFM)

data(AFMImageOfAluminiumInterface)
p<-getSpplotFromAFMImage(AFMImageOfAluminiumInterface, 800,800, TRUE)
print(p)
}
}
\author{
M.Beauvais
}

