% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AFM3DPrinter.R
\name{displayIn3D}
\alias{displayIn3D}
\title{Display a 3D image of an AFMImage and store it on disk.}
\usage{
displayIn3D(AFMImage, width, fullfilename, changeViewpoint)
}
\arguments{
\item{AFMImage}{the AFM image to be displayed in three dimensions.}

\item{width}{(optional)  width of the image. Default is 512 pixels. Note: width can't be superior to screen resolution.}

\item{fullfilename}{(optional) the directory and filename to save the png of the 3D image. If this variable is missing, the function will not save on disk the 3D image.}

\item{changeViewpoint}{(optional) if TRUE, the viewpoint is changed. Default is TRUE.}
}
\description{
Display a 3D image of an AFMImage and store it on disk if fullfilename variable is set.
It uses the \code{\link{rgl}} package.
}
\examples{
library(AFM)

data(AFMImageOfAluminiumInterface)
newAFMImage<-extractAFMImage(AFMImageOfAluminiumInterface, cornerX=50, cornerY=50, size=256)
displayIn3D(newAFMImage, 1024)

\dontrun{
AFMImage<-importFromNanoscope("/user/ubuntu/myNanoscopeAnalysisAFMImage.txt")
displayIn3D(AFMImage, 1024, "/users/ubuntu/myRglAFMimage.png")
}
}
\author{
M.Beauvais
}

