% File src/library/grid/man/grid-package.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2007 R Core Development Team
% Distributed under GPL 2 or later

\name{grid-package}
\alias{grid-package}
\docType{package}
\title{
  The Grid Graphics Package
}
\description{
  A rewrite of the graphics layout capabilities, plus some
  support for interaction.
}
\details{
This package contains a graphics system which supplements
S-style graphics (see the \pkg{graphics} package).

Further information is available in the following
\link{vignettes}:
\tabular{ll}{
\code{grid} \tab Introduction to \code{grid} (\url{../doc/grid.pdf})\cr
\code{displaylist} \tab Display Lists in \code{grid} (\url{../doc/displaylist.pdf})\cr
\code{frame} \tab Frames and packing grobs (\url{../doc/frame.pdf})\cr
\code{grobs} \tab Working with \code{grid} grobs (\url{../doc/grobs.pdf})\cr
\code{interactive} \tab Editing \code{grid} Graphics (\url{../doc/interactive.pdf})\cr
\code{locndimn} \tab Locations versus Dimensions (\url{../doc/locndimn.pdf})\cr
\code{moveline} \tab Demonstrating move-to and line-to (\url{../doc/moveline.pdf})\cr
\code{nonfinite} \tab How \code{grid} responds to non-finite values (\url{../doc/nonfinite.pdf})\cr
\code{plotexample} \tab Writing \code{grid} Code (\url{../doc/plotexample.pdf})\cr
\code{rotated} \tab Rotated Viewports (\url{../doc/rotated.pdf})\cr
\code{saveload} \tab Persistent representations (\url{../doc/saveload.pdf})\cr
\code{sharing} \tab Modifying multiple grobs simultaneously (\url{../doc/sharing.pdf})\cr
\code{viewports} \tab Working with \code{grid} viewports (\url{../doc/viewports.pdf})\cr
}

For a complete list of functions with individual help pages,
use \code{library(help="grid")}.
}
\author{

Paul Murrell \email{paul@stat.auckland.ac.nz}

Maintainer: R Core Team \email{R-core@r-project.org}

}
\references{
  Murrell, P. (2005) \emph{R Graphics}. Chapman & Hall/CRC Press.
}
\keyword{package}
