\name{gam2objective}
\alias{gam2objective}
\alias{gam2derivative}
\alias{gam3objective}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Objective functions for GAM smoothing parameter estimation. }
\description{Estimation of GAM smoothing parameters is most stable if
optimization of the UBRE or GCV score is outer to the penalized iteratively
re-weighted least squares scheme used to estimate the model given smoothing 
parameters. These functions evaluate the GCV/UBRE score of a GAM model, given
smoothing parameters, in a manner sutable for use by \code{\link{optim}} or \code{\link{nlm}}.
Not normally called directly, but rather service routines for \code{\link{gam.outer}}.
}
\usage{
gam2objective(lsp,args)
gam2derivative(lsp,args)
gam3objective(lsp,args)
}
%- maybe also `usage' for other objects documented here.
\arguments{ 
\item{lsp}{The log smoothing parameters.}

\item{args}{List of arguments required to call \code{\link{gam.fit2}}.}
}
\details{ \code{gam2objective} and \code{gam2derivative} are functions suitable
for calling by \code{\link{optim}}, to evaluate the GCV/UBRE score and it's
derivatives w.r.t. log smoothing parameters.

\code{gam3objective} is an equaivalent to \code{gam2objective}, suitable for
optimization by \code{\link{nlm}} - derivatives of the GCV/UBRE function are
calculated and returned as attributes.

The basic idea of optimizing smoothing parameters `outer' to the P-IRLS loop
was first proposed in O'Sullivan et al. (1986).
}

\references{

O 'Sullivan, Yandall & Raynor (1986) Automatic smoothing of regression
functions in generalized linear models. J. Amer. Statist. Assoc. 81:96-103.

\url{http://www.stats.gla.ac.uk/~simon/}

}
\author{ Simon N. Wood \email{simon.wood@r-project.org}}


\seealso{\code{gam.fit2},  \code{\link{gam}}, \code{\link{mgcv}}, \code{\link{magic}}}


\keyword{models} \keyword{smooth} \keyword{regression}%-- one or more ...






