\name{downs.bc}
\alias{downs.bc}
\title{
Incidence of Down's Syndrome in British Columbia
}
\description{
The \code{downs.bc} data frame has 30 rows and 3 columns.


Down's syndrome is a genetic disorder caused by an extra chromosome 21 or
a part of chromosome 21 being translocated to another chromosome.  The 
incidence of Down's syndrome is highly dependent on the mother's age and rises
sharply after age 30.  In the 1960's a large scale study of the effect of
maternal age on the incidence of Down's syndrome was conducted at the
British Columbia Health Surveillance Registry.  These are the data which was
collected in that study. 


Mothers were classified by age. Most groups correspond to the age in years but
the first group comprises all mothers with ages in the range 15-17 and the 
last is those with ages 46-49.  No data for
mothers over 50 or below 15 were collected. 
}
\usage{
downs.bc
}
\format{
This data frame contains the following columns:


\describe{
\item{\code{age}}{
The average age of all mothers in the age category.
}
\item{\code{m}}{
The total number of live births to mothers in the age category.
}
\item{\code{r}}{
The number of cases of Down's syndrome.
}}}
\source{
The data were obtained from


Geyer, C.J. (1991) Constrained maximum likelihood exemplified by isotonic 
convex logistic regression. 
\emph{Journal of the American Statistical Association}, \bold{86}, 717--724.
}
\references{
Davison, A.C. and Hinkley, D.V. (1997) 
\emph{Bootstrap Methods and Their Application}. Cambridge University Press.
}
\keyword{datasets}
% Converted by Sd2Rd version 1.15.
