\name{nls}
\alias{nls}
\alias{anova.nls}
\alias{anovalist.nls}
\alias{coef.nls}
\alias{deviance.nls}
\alias{df.residual.nls}
\alias{fitted.nls}
\alias{logLik.nls}
\alias{print.nls}
\alias{residuals.nls}
\alias{summary.nls}
\alias{print.summary.nls}
\alias{weights.nls}
\alias{AIC.nls}
\title{Nonlinear Least Squares}
\usage{
nls(formula, data, start, control = nls.control(),
    algorithm = "default", trace = FALSE, subset,
    weights, na.action)
}
\arguments{
 \item{formula}{a nonlinear model formula including variables and parameters}
 \item{data}{an optional data frame in which to evaluate the variables in
     \code{formula}}
 \item{start}{a named list or named numeric vector of starting estimates}
 \item{control}{an optional list of control settings.  See
     \code{nls.control} for the names of the settable control values and
     their effect.}
 \item{algorithm}{character string specifying the algorithm to use.
     The default algorithm is a Gauss-Newton algorithm. The other 
     alternative is "plinear", the Golub-Pereyra algorithm for
     partially linear least-squares models.}
 \item{trace}{logical value indicating if a trace of the iteration
     progress should be printed.  Default is \code{FALSE}.  If
     \code{TRUE} the residual sum-of-squares and the parameter values
     are printed at the conclusion of each iteration.  When the
     \code{"plinear"} algorithm is used, the conditional estimates of
     the linear parameters are printed after the nonlinear parameters.}
 \item{subset}{an optional vector specifying a subset of observations
   to be used in the fitting process.}
 \item{weights}{an optional numeric vector of (fixed) weights.  When
   present, the objective function is weighted least squares. \emph{not
     yet implemented}}
\item{na.action}{a function which indicates what should happen
    when the data contain \code{NA}s.}
}
\description{
  Determine the nonlinear least squares estimates of the nonlinear model
  parameters and return a class \code{nls} object.
}
\details{
  An \code{nls} object is a type of fitted model object.  It has methods
  for the generic functions \code{coef}, \code{formula}, \code{resid},
  \code{print}, \code{summary}, \code{AIC}, and \code{fitted}.
}
\value{
  A list of
  \item{m}{an \code{nlsModel} object incorporating the model}
  \item{data}{the expression that was passed to \code{nls} as the data
    argument.  The actual data values are present in the environment of
    the \code{m} component.}
}
\references{
  Bates, D.M. and Watts, D.G. (1988)
  \emph{Nonlinear Regression Analysis and Its Applications},
  Wiley
}
\author{Douglas M. Bates and Saikat DebRoy}
\seealso{\code{\link{nlsModel}}}
\examples{
data( DNase )
DNase1 <- DNase[ DNase$Run == 1, ]
## using a selfStart model
fm1DNase1 <- nls( density ~ SSlogis( log(conc), Asym, xmid, scal ), DNase1 )
summary( fm1DNase1 )
## using conditional linearity
fm2DNase1 <- nls( density ~ 1/(1 + exp(( xmid - log(conc) )/scal ) ),
                  data = DNase1,
                  start = list( xmid = 0, scal = 1 ),
                  alg = "plinear", trace = TRUE )
summary( fm2DNase1 )
## without conditional linearity
fm3DNase1 <- nls( density ~ Asym/(1 + exp(( xmid - log(conc) )/scal ) ),
                  data = DNase1,
                  start = list( Asym = 3, xmid = 0, scal = 1 ),
                  trace = TRUE )
summary( fm3DNase1 )
## weighted nonlinear regression
data(Puromycin)
Treated <- Puromycin[Puromycin$state == "treated", ]
weighted.MM <- function(resp, conc, Vm, K)
{
    ## Purpose: exactly as white book p.451 -- RHS for nls()
    ##  Weighted version of Michaelis-Menten model
    ## -------------------------------------------------------------------------
    ## Arguments: `y', `x' and the two parameters (see book)
    ## -------------------------------------------------------------------------
    ## Author: Martin Maechler, Date: 23 Mar 2001, 18:48

    pred <- (Vm * conc)/(K + conc)
    (resp - pred) / sqrt(pred)
}

Pur.wt <- nls( ~ weighted.MM(rate, conc, Vm, K), data = Treated,
              start = list(Vm = 200, K = 0.1),
              trace = TRUE)
}
\keyword{nonlinear}
\keyword{regression}
\keyword{models}
