\name{Arithmetic}
\title{Arithmetic Operators}
\usage{
x + y
x - y
x * y
x / y
x ^ y
x \%\% y
x \%/\% y
}
\alias{+}
\alias{-}
\alias{*}
\alias{/}
\alias{^}
\alias{\%\%}
\alias{\%/\%}
\alias{Arithmetic}
\description{
These binary operators perform arithmetic on vector objects.
}
\value{
They return numeric vectors containing the result of the element
by element operations.  The elements of shorter vectors are recycled
as necessary (with a \code{\link{warning}} when they are recycled only
\emph{fractionally}).  The operators are \code{+} for addition,
\code{-} for subtraction \code{*} for multiplication, \code{/} for
division and \code{^} for exponentiation.

\code{\%\%} indicates \code{x mod y} and \code{\%/\%} indicates integer
division.  It is guaranteed that \code{x  ==  (x \%\% y)  +  y * ( x \%/\% y )}
unless \code{y == 0} where the result is \code{\link{NA}} or
\code{\link{NaN}} (depending on the \code{\link{typeof}} of the arguments).
}
\details{
    \code{1 ^ y} and \code{y ^ 0} are \code{1}, \emph{always}.
    \code{x ^ y} should also give the proper ``limit'' result when
    either argument is infinite (i.e., \code{+- \link{Inf}}).

    Objects such as arrays or time-series can be operated on this
    way provided they are conformable.
}
\seealso{
\code{\link{Math}} for miscellaneous and \code{\link{Special}} for special
mathematical functions.
}
\examples{
x <- -1:12
x + 1
2 * x + 3
x \%\% 2 #-- is periodic
x \%/\% 5
}
\keyword{arith}
