\name{tempfile}
\title{Create Unique Names for (Temporary) Files}
\usage{
tempfile(pattern = "file")
}
\alias{tempfile}
\arguments{
  \item{pattern}{a character vector with the beginnings of the returned
    file names.}
}
\value{
  A character vector giving of names of possible (temporary) files.  The
  names are certain to be unique between subsequent calls.  Note that no
  files are generated by \code{tempfile}.
}
\seealso{\code{\link{unlink}} for deleting files.}
\examples{
## One possibility of getting ALL environment variables;
## compare with `getenv':
fun <- function() {
  FILE <- tempfile("fun")
  on.exit(unlink(FILE))
  system(paste("printenv >", FILE))
  x <- strsplit(scan(FILE, what = ""), "=")
  v <- n <- character(LEN <- length(x))
  for (i in 1:LEN) {
    n[i] <- x[[i]][1]
    v[i] <- paste(x[[i]][-1], collapse = "=")
  }
  structure(v, names = n)
}
fun()
}
\keyword{file}
