\name{t.test}
\title{Student's t-Test}
\usage{
t.test(x, y = NULL, alternative = "two.sided", mu = 0, paired = FALSE,
       var.equal = FALSE, conf.level = 0.95)
}
\alias{t.test}
\arguments{
  \item{x}{a numeric vector of data values.}
  \item{y}{an optional numeric vector data values.}
  \item{alternative}{must be one of \code{"two.sided"}, \code{"greater"}
    or \code{"less"}.  You can specify just the initial letter.  This
    parameter indicates the alternative hypothesis.}
  \item{mu}{a number indicating the true value of the mean (or
    difference in means if you are performing a two sample test).}
  \item{paired}{a logical indicating whether you want a paired t-test.}
  \item{var.equal}{a logical variable indicating whether to treat the
    two variances as being equal. If \code{TRUE} then the pooled
    variance is used to estimate the variance otherwise the Welch
    approximation to the degrees of freedom is used.}
  \item{conf.level}{confidence level of the interval.}
}
\description{
  t.test performs one and two sample t-tests on vectors of data.
  If \code{paired} is \code{TRUE} then both \code{x} and \code{y} must
  be specified and they must be the same length.
  Missing values are removed (in pairs if \code{paired} is
  \code{TRUE}).  If \code{var.equal} is \code{TRUE} then the pooled
  estimate of the variance is used. If \code{var.equal} is \code{FALSE}
  then the variance is estimated separately for both groups and the
  Welch modification to the degrees of freedom is used.
}
\value{
  A list with class \code{"htest"} containing the following components:
  \item{statistic}{the value of the t-statistic.}
  \item{parameters}{the degrees of freedom for the t-statistic.}
  \item{p.value}{the p-value for the test.}
  \item{conf.int}{a confidence interval for the mean appropriate to the
    specified alternative hypothesis.}
  \item{estimate}{the estimated mean or difference in means depending on
    whether it was a one-sample test or a two-sample test.}
  \item{null.value}{the specified hypothesized value of the mean or mean
    difference depending on whether it was a one-sample test or a
    two-sample test.}
  \item{alternative}{a character string describing the alternative
    hypothesis.}
  \item{method}{a character string indicating what type of t-test was
    performed.}
  \item{data.name}{a character string giving the name(s) of the data.}
}
\keyword{htest}
