% File src/library/grid/man/gridCoords.Rd
% Part of the R package, https://www.R-project.org
% Copyright 1995-2007 R Core Team
% Distributed under GPL 2 or later

\name{gridCoords}
\alias{gridCoords}
\alias{gridGrobCoords}
\alias{gridGTreeCoords}
\alias{emptyCoords}
\alias{emptyGrobCoords}
\alias{emptyGTreeCoords}
\alias{isEmptyCoords}
\title{Create Sets of Coordinates for Grid Grobs}
\description{
  These functions support the development of \code{\link{grobPoints}}
  methods for custom grobs.
}
\usage{
gridCoords(x, y)
gridGrobCoords(x, name, rule = NULL)
gridGTreeCoords(x, name)
emptyCoords
emptyGrobCoords(name)
emptyGTreeCoords(name)
isEmptyCoords(coords)
}
\arguments{
  \item{x}{For \code{gridCoords} a numeric vector.  For
    \code{gridGrobCoords} a list of \code{"GridCoords"} objects.
    For \code{gridGTreeCoords} a list of either \code{"GridGrobCoords"}
    or \code{"GridGTreeCoords"} objects.}
  \item{y}{ A numeric vector.}
  \item{name}{ A character value. }
  \item{rule}{A fill rule, either \code{"winding"} or \code{"evenodd"},
    or \code{NULL}.}
  \item{coords}{A set of grob coordinates (as generated by \code{grobCoords}).}
}
\details{
  These functions help the developer of a \code{grobPoints} method
  to generate the coordinates from a custom grob.

  The \code{emptyCoords} object can be used to return a "null"
  result (e.g., when asking for \code{closed} coordinates on an
  open line) and the \code{isEmptyCoords} function can be used to check for
  "null" results.
}
\value{
  For \code{gridCoords} a \code{"GridCoords"} object.
  For \code{gridGrobCoords} a \code{"GridGrobCoords"} object.
  For \code{gridGTreeCoords} a \code{"GridGTreeCoords"} object.
}
\author{Paul Murrell}
\keyword{dplot}
